<?php

namespace App\Http\Controllers;

use App\Http\Requests\ProvinceRequest;
use App\Models\entidade;
use App\Models\Province;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Nette\Utils\Strings;

use function PHPUnit\Framework\isInt;

class ProvinceController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(){
        $user =  auth()->user();
        $provinces = DB::table('provinces')
        ->join('entidades','entidades.id','=','provinces.entidade_id')
        ->join('users','users.id','=','provinces.user_id')
        ->select('users.name', 'entidades.nome as nomeEntidade', 'provinces.*')
        ->where("entidades.id",$user->entidade_id)
        ->paginate(10);
        // dd($provinces);
        return view('provincia.index',compact('provinces','user'));
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $user =  auth()->user();
        if($user->role_id==1 or $user->role_id==2){
             $users = DB::table('users')
            ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
            ->join('roles', 'users.role_id', '=', 'roles.id')
            ->join('estados', 'users.estado_id', '=', 'estados.id')
            ->select('users.*','roles.role')
            ->where(["users.entidade_id"=>$user->entidade_id,"estados.id"=>1])
            ->orderBy("name")
            ->get();
          
            return view('provincia.create',compact('users','user'));

        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(ProvinceRequest $request)
    {
        $user =  auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $dados = $request->all();
            $user = User::find($dados['user']);
            $Entidade = entidade::find($user->entidade_id);
            $provincia = Province::create(
                [
                'nome'=>$dados['nome'],
                'codigo'=>$dados['codigo'],
                'latitude'=>$dados['lat'],
                'longitude'=>$dados['long'],
                'precision'=>$dados['precision'],
                'entidade_id'=>$Entidade->id,
                'user_id'=>$user->id, // responsável
                ]
            );
            return redirect()->route('provincia.create');
            
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
            
    }

    /**
     * Display the specified resource.
     */
    public function show(Province $province)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(String $id)
    {
        
        $user =  auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $users = DB::table('users')
            ->join('entidades', 'users.entidade_id', '=', 'entidades.id')
            ->join('roles', 'users.role_id', '=', 'roles.id')
            ->join('estados', 'users.estado_id', '=', 'estados.id')
            ->select('users.*','roles.role')
            ->where(["users.entidade_id"=>$user->entidade_id,"estados.id"=>1])
            ->orderBy("name")
            ->get();
            //* *//
            $province = Province::findOrFail($id);
            if($province->entidade_id == $user->entidade_id){
                //dd($province);
                // dd($users);
                return view('provincia.edit',compact('users','province'));
            }else{
                abort(403,'Não autorizado.');
                exit();
            }
        }else{
            abort(403,'Não autorizado.');
            exit();
        }
            
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(ProvinceRequest $request,String $id){
        if(!isInt($id))
            $id=0;

        $user = auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $province = Province::findOrFail($id);
            if($province->entidade_id == $user->entidade_id){
                $dados = $request->all();
               
                // dd($dados);
                $lat='0.0';
                if(!empty($dados['lat'])){
                    $lat=$dados['lat'];
                }

                $long='0.0';
                if(!empty($dados['long'])){
                    $long=$dados['long'];
                }

                $precision='0.0';
                if(!empty($dados['precision'])){
                    $precision=$dados['precision'];
                }
                
                $province->update(
                    [
                        
                        'nome'=>$dados['nome'],
                        'codigo'=>$dados['codigo'],
                        'latitude'=>$lat,
                        'longitude'=>$long,
                        'precision'=>$precision,
                        'user_id'=>$dados['user']
                    ]
                );
                return redirect()->back();
            }else{
                abort(403,'Não autorizado.');
                exit();
            }
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
        return redirect()->back();
        
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        $id = $request->valor;
        if(!isInt($id))
        { 
            $id=0;
        }

        $user = auth()->user();
        if($user->role_id==1 or $user->role_id==2){
            $province = Province::findORFail($id);
            $province->delete();
            return redirect()->back();
        }else{
            abort(403, 'Não autorizado.');
            exit();
        }
    }
}
